
/*============================================================================
 Name        : libtype.h
 Author      :
 Date  	     : 2015.9
 Copyright   : ZKSoftware Inc.
 Description : Linux C
 ============================================================================*/

#ifndef 	_LIBTYPE_H_
#define 	_LIBTYPE_H_

typedef     unsigned char       U8;         // unsigned 8 bit integer
typedef     signed char         S8;         // signed 8 bit integer

typedef     unsigned short      U16;        // unsigned 16 bit integer
typedef     signed short        S16;        // signed 16 bit integer

typedef     unsigned long       U32;        // unsigned 32 bit integer
typedef     signed long         S32;        // signed 32 bit integer

typedef     char                CHAR;       // char
typedef     short               SHORT;      // short
typedef     int                 INT;        // int

typedef     float               FLOAT;      // float
typedef     double              DOUBLE;     // double
typedef     void                VOID;       // void
typedef     void *              pVOID;      // void *

#define 	DEMOVERSION			"V2.0.A.2_20151127"
#define		SDKVERSION			"V2.0.2.20151127"
#define 	DEV_USB				0
#define 	DEV_232				1

#define 	USBPID				0x0121
#define 	USBVID				0x1B55
#define 	FIRMWARE			"SilkID.bin"
#define 	DEBUG_FILE			"debug.log"
#define		USER_DIR			"./User"
#define 	TEMPLATE_DIR		"./Templates"
#define		LOGS_DIR			"./Logs"

#ifndef 	DEBUG
#define 	DEBUG				1	//debug info output to file
#endif

#define 	USERID_MAX			65535
#define     FALSE       		-1			
#define     TRUE        		0
#define		FAILURE				0
#define		SUCCESS				1

#define 	DIRSIZE				256

#define		IMAGE_SIZE			(400 * 400)
#define		IMAGE_WIDTH			288
#define		IMAGE_HEIGHT		362
#define 	TEMPLATES_SIZE		(1024*2)
#define 	HEADSIZE			13



#define 	ERR_FAIL 				0x63
#define 	ERR_TIME_OUT			0x6C
#define 	ERR_MEM_FULL			0x6D
#define 	ERR_PARAM_ERROR			0x68
#define 	ERR_NOT_FIND 			0x69
#define 	ERR_FP_LIMIT			0x72
#define 	ERR_INVALID_ID			0x76
#define 	ERR_CANCELED			0x81
#define 	ERR_DATA_ERROR			0x82
#define 	ERR_EXIST_FP			0x86

#define		DATA_OK					0x83
#define		FLAG_OK					0x61

#define MD_UPDATE_FW		0x72
#define MD_DISABLEDEVICE	0xFA
#define MD_ENABLEDEVICE		0xFB
#define MD_RESET			0xD0
#define MD_DISCONNECT		0xCC
#define MD_SYS_WP			0x11	//write
#define MD_SYS_SP			0x12	//save
#define MD_SYS_RP			0x13	//read
#define MD_SYS_STATUS		0x14	//status
#define MD_ENROLL_SCAN		0x15	//EnrollUserByScan
#define	MD_ENROLL_TMP		0x17
#define MD_VERIFY_SCAN		0X18
#define MD_DEL_TMP			0x26
#define MD_DEL_ALL_TMP		0x27
#define	MD_ENROLL_IMAGE_X	0x80
#define	MD_IDENTIFY_IMAGE_X 0x81
#define MD_SCAN_IMAGE_X		0x83
#define MD_READ_TMP_X		0x89
#define MD_ADD_USER			0xF1
#define MD_READ_USER		0xF2
#define MD_DELETE_USER		0xF3
#define MD_DEL_ALL_USER		0xF5
#define MD_SET_TIME			0x4A
#define MD_GET_TIME			0x4B
#define MD_DEL_ALOG			0x9E
#define MD_LOAD_LOG_X		0xA4
#define MD_LOAD_USER_X		0xA0
#define MD_LOAD_TMP_X		0xA2
#define MD_DEL_DB			0xF8
#define MD_SCAN_TEMPLATE	0xFC
#define MD_IDENTIFY_FREE	0x2F


//system parameter
#define SID_MODULE_IDENTIFY 0x50
#define SID_TIMEOUT			0x62	//time out
#define SID_IMAGE_FMT		0x6C	//image format
#define SID_MODULE_ID		0x6D	//module id
#define SID_FW_VER			0x6E	//firmware version
#define SID_SERIAL_NUM		0x6F	//serial number
#define SID_BAUDRATE		0x71	//baudrate 57600
#define SID_ENROLL_FP		0x73	//Current number of Enrolled fp
#define SID_FP_COUNT		0x74	// the available number of fp that can  be enrolled
#define SID_USER_COUNT		0x79	//Max user count
#define SID_USER_NUM		0x7A	// Enreolled user number
#define SID_LOG_COUNT		0x7B	//maximum Log Count
#define SID_LOG_NUM			0x7C	//Log number
#define SID_FP_WAV			0x7D	//FP wav
#define SID_AUTO_ACK		0x82	// auto response when free scan
#define SID_BUILD_NUM		0x89	//builed number

#define SID_GPIO_LEVEL		0x31	// GPIO level
#define SID_EMPTY_ADMIN		0x33	//SID_EMPTY_ADMIN
#define SID_SAVE_LOG		0x36	// save log
#define SID_VOICE_ON		0x37	// voice on
#define SID_ENCRY_ON		0x40	// encryption switch
#define SID_VOL_CTL			0x43	// vol control
#define SID_LOG_DELAY		0x45 	// flag for rotating sensor image in capture
#define SID_CHECK_FP		0x46 	// is check fp
#define SID_BEEP_LEVEL		0x47
#define SID_FP_VER			0xAA	// fp version 10/9

#endif


